<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.111.3.9.10.28
Name: Verwijderen Verwijzing
Description: 
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" id="template-2.16.840.1.113883.2.4.3.111.3.9.10.28-2016-11-01T133354">
    <title>Verwijderen Verwijzing</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.28
Context: /
Item: (MFMT_IN002303NL)
-->
    <rule context="/" id="d836099e2180-false-d876717e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:MFMT_IN002303NL)&gt;=1">(MFMT_IN002303NL): element hl7:MFMT_IN002303NL is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:MFMT_IN002303NL)&lt;=1">(MFMT_IN002303NL): element hl7:MFMT_IN002303NL komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.28
Context: /hl7:MFMT_IN002303NL
Item: (MFMT_IN002303NL)
-->
    <rule context="/hl7:MFMT_IN002303NL" id="d836099e2187-false-d876742e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="hl7:acceptAckCode/@code = 'AL'">(MFMT_IN002303NL): hl7:acceptAckCode/@code moet de waarde “AL” bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/@classCode) = 0 or (count(hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/@classCode) &gt; 0 and hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/@classCode = 'REG')">(MFMT_IN002303NL): Moet, indien aanwezig, de vaste waarde “REG” bevatten.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test=" hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/@moodCode = 'RQO'">(MFMT_IN002303NL): Moet de vaste waarde “RQO” bevatten.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:statusCode/@code = 'nullified'">(MFMT_IN002303NL): Het attribuut @code moet de waarde “nullified” hebben.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:effectiveTime/@nullFlavor = 'UNK'">(MFMT_IN002303NL): Het attribuut @nullFlavor moet de waarde “UNK” hebben.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(MFMT_IN002303NL): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:id[not(@nullFlavor)])&lt;=1">(MFMT_IN002303NL): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:creationTime[not(@nullFlavor)])&gt;=1">(MFMT_IN002303NL): element hl7:creationTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:creationTime[not(@nullFlavor)])&lt;=1">(MFMT_IN002303NL): element hl7:creationTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)])&gt;=1">(MFMT_IN002303NL): element hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)])&lt;=1">(MFMT_IN002303NL): element hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:interactionId[@root='2.16.840.1.113883.1.6'])&gt;=1">(MFMT_IN002303NL): element hl7:interactionId[@root='2.16.840.1.113883.1.6'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:interactionId[@root='2.16.840.1.113883.1.6'])&lt;=1">(MFMT_IN002303NL): element hl7:interactionId[@root='2.16.840.1.113883.1.6'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1'])&gt;=1">(MFMT_IN002303NL): element hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1'])&lt;=1">(MFMT_IN002303NL): element hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:processingCode[@code='P'][not(@nullFlavor)])&gt;=1">(MFMT_IN002303NL): element hl7:processingCode[@code='P'][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:processingCode[@code='P'][not(@nullFlavor)])&lt;=1">(MFMT_IN002303NL): element hl7:processingCode[@code='P'][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:processingModeCode[@code='T'][not(@nullFlavor)])&gt;=1">(MFMT_IN002303NL): element hl7:processingModeCode[@code='T'][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:processingModeCode[@code='T'][not(@nullFlavor)])&lt;=1">(MFMT_IN002303NL): element hl7:processingModeCode[@code='T'][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:acceptAckCode[@code='AL' or @code='NE'][not(@nullFlavor)])&gt;=1">(MFMT_IN002303NL): element hl7:acceptAckCode[@code='AL' or @code='NE'][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:acceptAckCode[@code='AL' or @code='NE'][not(@nullFlavor)])&lt;=1">(MFMT_IN002303NL): element hl7:acceptAckCode[@code='AL' or @code='NE'][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:receiver)&gt;=1">(MFMT_IN002303NL): element hl7:receiver is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:receiver)&lt;=1">(MFMT_IN002303NL): element hl7:receiver komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:sender[not(@nullFlavor)])&gt;=1">(MFMT_IN002303NL): element hl7:sender[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count(hl7:sender[not(@nullFlavor)])&lt;=1">(MFMT_IN002303NL): element hl7:sender[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <let name="transmission" value="."/>
        <let name="interactionId" value="$transmission/local-name()"/>
        <let name="interactionVocabFile" value="'../vocab/2.16.840.1.113883.1.6.xml'"/>
        <let name="interactionVocab" value="if (doc-available($interactionVocabFile)) then doc($interactionVocabFile) else ()"/>
        <let name="interactionName" value="$interactionVocab/*/hl7:code[@code=$interactionId]/@displayName"/>
        <let name="isActive" value="not(exists($interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Actief'][@value='false']))"/>
        <let name="allowBsn" value="exists($interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='AttentionLineMetBsn'][@value='true'])"/>
        <let name="allowContextCode" value="exists($interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='AttentionLineMetContextCode'][@value='true'])"/>
        <let name="senderGbpOrGbk" value="exists($transmission/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:code[@codeSystem=('2.16.840.1.113883.2.4.3.11.8','2.16.840.1.113883.2.4.3.11.6')])"/>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="$interactionVocab">(MFMT_IN002303NL): Transmission: <value-of select="$interactionVocabFile"/> niet gevonden. Controles gebaseerd op dit externe configuratiebestand zijn gedeactiveerd.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="not($interactionVocab) or $isActive">(MFMT_IN002303NL): Transmission: deze interactie <value-of select="$interactionId"/> (<value-of select="$interactionName"/>) is niet (meer) Actief in <value-of select="$interactionVocabFile"/>
        </assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="not($interactionVocab) or not($allowBsn) or $transmission/hl7:attentionLine/hl7:keyWordText[@code=('FICID','PATID')][@codeSystem='2.16.840.1.113883.2.4.15.1']">(MFMT_IN002303NL): Transmission: er moet in deze interactie exact één AttentionLine met BSN zitten - <value-of select="$interactionId"/> (<value-of select="$interactionName"/>)</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="not($interactionVocab) or  not($allowContextCode) or $transmission/hl7:attentionLine/hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']">(MFMT_IN002303NL): Transmission: er moet in deze interactie exact één AttentionLine met de ContextCode zitten - <value-of select="$interactionId"/> (<value-of select="$interactionName"/>)</assert>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="not($interactionVocab) or not($transmission/hl7:attentionLine/hl7:keywordText[@code=('FICID','PATID')][@codeSystem='2.16.840.1.113883.2.4.15.1']) or $allowBsn or $senderGbpOrGbk">(MFMT_IN002303NL): Transmission: deze interactie <value-of select="$interactionId"/> (<value-of select="$interactionName"/>) is niet geconfigureerd voor gebruik van het element <value-of select="local-name()"/> voor BSN in <value-of select="$interactionVocabFile"/> en afzender is niet GBK of GBP</assert>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="not($interactionVocab) or not($transmission/hl7:attentionLine/hl7:keywordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']) or $allowContextCode or $senderGbpOrGbk">(MFMT_IN002303NL): Transmission: deze interactie <value-of select="$interactionId"/> (<value-of select="$interactionName"/>) is niet geconfigureerd voor gebruik van het element <value-of select="local-name()"/> voor ContextCode in <value-of select="$interactionVocabFile"/> en afzender is niet GBK of GBP</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count($transmission/hl7:attentionLine/hl7:keyWordText[@code=('FICID','PATID')][@codeSystem='2.16.840.1.113883.2.4.15.1'])&lt;=1">(MFMT_IN002303NL): Transmission: er mag maximaal één AttentionLine met BSN zijn - <value-of select="$interactionId"/> (<value-of select="$interactionName"/>)</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.28" test="count($transmission/hl7:attentionLine/hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1'])&lt;=1">(MFMT_IN002303NL): Transmission: er mag maximaal één AttentionLine met de ContextCode zijn - <value-of select="$interactionId"/> (<value-of select="$interactionName"/>)</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:MFMT_IN002303NL/hl7:id[not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:id[not(@nullFlavor)]" id="d876748e136-false-d876895e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="@root and @extension">(MCCI_MT000100): Transmission: id element mist root of extension</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:MFMT_IN002303NL/hl7:creationTime[not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:creationTime[not(@nullFlavor)]" id="d876748e141-false-d876908e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS.DATETIME.MIN"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="not(*)">(MCCI_MT000100): <value-of select="local-name()"/> met datatype TS.DATETIME.MIN, MAG GEEN elementen bevatten.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:MFMT_IN002303NL/hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)]" id="d876748e146-false-d876924e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="@nullFlavor or (@code='NICTIZEd2005-Okt')">(MCCI_MT000100): de elementwaarde MOET een zijn van 'code 'NICTIZEd2005-Okt''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:MFMT_IN002303NL/hl7:interactionId[@root='2.16.840.1.113883.1.6']
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:interactionId[@root='2.16.840.1.113883.1.6']" id="d876748e150-false-d876943e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="string(@root)=('2.16.840.1.113883.1.6')">(MCCI_MT000100): de waarde van @root MOET '2.16.840.1.113883.1.6' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="not(@root='2.16.840.1.113883.1.6') or local-name(..)=@extension">(MCCI_MT000100): Transmission: @extension moet overeenkomen met het startelement van het bericht</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:MFMT_IN002303NL/hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1']
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1']" id="d876748e156-false-d876960e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="string(@root)=('2.16.840.1.113883.2.4.3.11.1')">(MCCI_MT000100): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.1' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="string(@extension)=('810')">(MCCI_MT000100): de waarde van @extension MOET '810' zijn.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:MFMT_IN002303NL/hl7:processingCode[@code='P'][not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:processingCode[@code='P'][not(@nullFlavor)]" id="d876748e161-false-d876981e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="@nullFlavor or (@code='P')">(MCCI_MT000100): de elementwaarde MOET een zijn van 'code 'P''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:MFMT_IN002303NL/hl7:processingModeCode[@code='T'][not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:processingModeCode[@code='T'][not(@nullFlavor)]" id="d876748e165-false-d877000e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="@nullFlavor or (@code='T')">(MCCI_MT000100): de elementwaarde MOET een zijn van 'code 'T''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:MFMT_IN002303NL/hl7:acceptAckCode[@code='AL' or @code='NE'][not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:acceptAckCode[@code='AL' or @code='NE'][not(@nullFlavor)]" id="d876748e170-false-d877019e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="@nullFlavor or (@code='AL') or (@code='NE')">(MCCI_MT000100): de elementwaarde MOET een zijn van 'code 'AL' of code 'NE''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.120
Context: /hl7:MFMT_IN002303NL/hl7:attentionLine
Item: (TransmissionWrapperAttentionLine)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:attentionLine" id="d877020e22-false-d877041e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="count(hl7:keyWordText[not(@nullFlavor)])&gt;=1">(TransmissionWrapperAttentionLine): element hl7:keyWordText[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="count(hl7:keyWordText[not(@nullFlavor)])&lt;=1">(TransmissionWrapperAttentionLine): element hl7:keyWordText[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="count(hl7:value[not(@nullFlavor)])&gt;=1">(TransmissionWrapperAttentionLine): element hl7:value[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="count(hl7:value[not(@nullFlavor)])&lt;=1">(TransmissionWrapperAttentionLine): element hl7:value[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.120
Context: /hl7:MFMT_IN002303NL/hl7:attentionLine/hl7:keyWordText[not(@nullFlavor)]
Item: (TransmissionWrapperAttentionLine)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:attentionLine/hl7:keyWordText[not(@nullFlavor)]" id="d877020e25-false-d877075e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='SC' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperAttentionLine): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:SC" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="SC"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.120
Context: /hl7:MFMT_IN002303NL/hl7:attentionLine/hl7:value[not(@nullFlavor)]
Item: (TransmissionWrapperAttentionLine)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:attentionLine/hl7:value[not(@nullFlavor)]" id="d877020e34-false-d877088e0">
        <extends rule="ANY"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="@xsi:type">(TransmissionWrapperAttentionLine): attribute @xsi:type MOET aanwezig zijn.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:MFMT_IN002303NL/hl7:receiver
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver" id="d876748e178-false-d877102e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="string(@typeCode)=('RCV') or not(@typeCode)">(MCCI_MT000100): de waarde van @typeCode MOET 'RCV' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="count(hl7:device[not(@nullFlavor)])&gt;=1">(MCCI_MT000100): element hl7:device[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="count(hl7:device[not(@nullFlavor)])&lt;=1">(MCCI_MT000100): element hl7:device[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]" id="d877109e20-false-d877131e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.6'])&gt;=1">(TransmissionWrapperDevice): element hl7:id[@root='2.16.840.1.113883.2.4.6.6'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.6'])&lt;=1">(TransmissionWrapperDevice): element hl7:id[@root='2.16.840.1.113883.2.4.6.6'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:name)&lt;=1">(TransmissionWrapperDevice): element hl7:name komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:agencyFor)&lt;=1">(TransmissionWrapperDevice): element hl7:agencyFor komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.6']
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.6']" id="d877109e23-false-d877171e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@root)=('2.16.840.1.113883.2.4.6.6')">(TransmissionWrapperDevice): de waarde van @root MOET '2.16.840.1.113883.2.4.6.6' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="@extension">(TransmissionWrapperDevice): attribute @extension MOET aanwezig zijn.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:name
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:name" id="d877109e28-false-d877192e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='EN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:EN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="EN"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor" id="d877109e31-false-d877205e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('AGNT') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'AGNT' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:representedOrganization)&lt;=1">(TransmissionWrapperDevice): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization" id="d877109e35-false-d877227e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('ORG') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'ORG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(TransmissionWrapperDevice): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(TransmissionWrapperDevice): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[not(@nullFlavor)])&lt;=1">(TransmissionWrapperDevice): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:NotificationParty)&lt;=1">(TransmissionWrapperDevice): element hl7:NotificationParty komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:id[not(@nullFlavor)]
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:id[not(@nullFlavor)]" id="d877109e38-false-d877278e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:name
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:name" id="d877109e41-false-d877291e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:telecom
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:telecom" id="d877109e44-false-d877304e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty" id="d877109e47-false-d877318e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('CON') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'CON' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:contactParty)&gt;=1">(TransmissionWrapperDevice): element hl7:contactParty is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:contactParty)&lt;=1">(TransmissionWrapperDevice): element hl7:contactParty komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:id
Item: (COCT_MT040203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:id" id="d877324e18-false-d877367e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:code
Item: (COCT_MT040203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:code" id="d877324e19-false-d877380e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:addr
Item: (COCT_MT040203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:addr" id="d877324e20-false-d877393e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:telecom
Item: (COCT_MT040203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:telecom" id="d877324e21-false-d877406e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty
Item: (COCT_MT040203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty" id="d877324e22-false-d877419e0">
        <let name="elmcount" value="count(hl7:Organization|hl7:Person)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="$elmcount&gt;=1">(COCT_MT040203): keuze (hl7:Organization of hl7:Person) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="$elmcount&lt;=1">(COCT_MT040203): keuze (hl7:Organization of hl7:Person) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="count(hl7:Organization)&lt;=1">(COCT_MT040203): element hl7:Organization komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="count(hl7:Person)&lt;=1">(COCT_MT040203): element hl7:Person komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization
Item: (COCT_MT040203)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('ORG') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'ORG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT150003): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:id)&gt;=1">(COCT_MT150003): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:code)&lt;=1">(COCT_MT150003): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:contact)&gt;=1">(COCT_MT150003): element hl7:contact is required [min 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:id
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:code
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:name
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:name">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('CON') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'CON' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:code)&lt;=1">(COCT_MT150003): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:contactPerson)&lt;=1">(COCT_MT150003): element hl7:contactPerson komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:id
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:code
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:addr
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:telecom
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson">
        <extends rule="d877643e22-false-d878337e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT150003): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:name)&gt;=1">(COCT_MT150003): element hl7:name is required [min 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name">
        <extends rule="d878323e21-false-d878412e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId">
        <extends rule="d878323e31-false-d878571e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson
Item: (COCT_MT030203)
-->
    <rule id="d877643e22-false-d878337e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT030203): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT030203): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:id)&gt;=1">(COCT_MT030203): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:administrativeGenderCode)&lt;=1">(COCT_MT030203): element hl7:administrativeGenderCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:birthTime)&lt;=1">(COCT_MT030203): element hl7:birthTime komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:id
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name
Item: (COCT_MT030203)
-->
    <rule id="d878323e21-false-d878412e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:administrativeGenderCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:administrativeGenderCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:birthTime
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:birthTime">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="not(*)">(COCT_MT030203): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:languageCode)&lt;=1">(COCT_MT030203): element hl7:languageCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:modeCode)&lt;=1">(COCT_MT030203): element hl7:modeCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:proficiencyLevelCode)&lt;=1">(COCT_MT030203): element hl7:proficiencyLevelCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:preferenceInd)&lt;=1">(COCT_MT030203): element hl7:preferenceInd komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:languageCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:languageCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:modeCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:modeCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:proficiencyLevelCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:preferenceInd
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:preferenceInd">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="BL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule id="d878323e31-false-d878571e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person
Item: (COCT_MT040203)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT030203): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT030203): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:id)&gt;=1">(COCT_MT030203): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:administrativeGenderCode)&lt;=1">(COCT_MT030203): element hl7:administrativeGenderCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:birthTime)&lt;=1">(COCT_MT030203): element hl7:birthTime komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:id
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:name
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:name">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:administrativeGenderCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:administrativeGenderCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:birthTime
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:birthTime">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="not(*)">(COCT_MT030203): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:languageCode)&lt;=1">(COCT_MT030203): element hl7:languageCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:modeCode)&lt;=1">(COCT_MT030203): element hl7:modeCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:proficiencyLevelCode)&lt;=1">(COCT_MT030203): element hl7:proficiencyLevelCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:preferenceInd)&lt;=1">(COCT_MT030203): element hl7:preferenceInd komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:languageCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:languageCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:modeCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:modeCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:proficiencyLevelCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:preferenceInd
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:preferenceInd">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="BL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:MFMT_IN002303NL/hl7:respondTo
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:respondTo" id="d876748e181-false-d878917e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="string(@typeCode)=('RSP') or not(@typeCode)">(MCCI_MT000100): de waarde van @typeCode MOET 'RSP' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="count(hl7:entityRsp[not(@nullFlavor)])&gt;=1">(MCCI_MT000100): element hl7:entityRsp[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="count(hl7:entityRsp[not(@nullFlavor)])&lt;=1">(MCCI_MT000100): element hl7:entityRsp[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:MFMT_IN002303NL/hl7:respondTo/hl7:telecom
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:respondTo/hl7:telecom" id="d876748e183-false-d878948e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:MFMT_IN002303NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]" id="d876748e184-false-d878961e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="not(@classCode) or (string-length(@classCode)&gt;0 and not(matches(@classCode,'\s')))">(MCCI_MT000100): attribuut @classCode MOET datatype 'cs' hebben</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@classCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.10882-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="not(@classCode) or count($theAttValue) = count($theAttCheck)">(MCCI_MT000100): de waarde van classCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.10882' EntityClass (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="not(@determinerCode) or (string-length(@determinerCode)&gt;0 and not(matches(@determinerCode,'\s')))">(MCCI_MT000100): attribuut @determinerCode MOET datatype 'cs' hebben</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@determinerCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.10878-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="not(@determinerCode) or count($theAttValue) = count($theAttCheck)">(MCCI_MT000100): de waarde van determinerCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.10878' EntityDeterminer (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(MCCI_MT000100): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:MFMT_IN002303NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]" id="d876748e189-false-d879021e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:MFMT_IN002303NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:name
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:name" id="d876748e190-false-d879034e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='EN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:EN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="EN"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:MFMT_IN002303NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:telecom
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:telecom" id="d876748e191-false-d879047e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.100
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]
Item: (MCCI_MT000100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]" id="d876748e192-false-d879061e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="string(@typeCode)=('SND') or not(@typeCode)">(MCCI_MT000100): de waarde van @typeCode MOET 'SND' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="count(hl7:device[not(@nullFlavor)])&gt;=1">(MCCI_MT000100): element hl7:device[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.100" test="count(hl7:device[not(@nullFlavor)])&lt;=1">(MCCI_MT000100): element hl7:device[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]" id="d879068e20-false-d879090e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.6'])&gt;=1">(TransmissionWrapperDevice): element hl7:id[@root='2.16.840.1.113883.2.4.6.6'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.6'])&lt;=1">(TransmissionWrapperDevice): element hl7:id[@root='2.16.840.1.113883.2.4.6.6'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:name)&lt;=1">(TransmissionWrapperDevice): element hl7:name komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:agencyFor)&lt;=1">(TransmissionWrapperDevice): element hl7:agencyFor komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.6']
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.6']" id="d879068e23-false-d879130e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@root)=('2.16.840.1.113883.2.4.6.6')">(TransmissionWrapperDevice): de waarde van @root MOET '2.16.840.1.113883.2.4.6.6' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="@extension">(TransmissionWrapperDevice): attribute @extension MOET aanwezig zijn.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:name
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:name" id="d879068e28-false-d879151e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='EN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:EN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="EN"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor" id="d879068e31-false-d879164e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('AGNT') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'AGNT' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:representedOrganization)&lt;=1">(TransmissionWrapperDevice): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization" id="d879068e35-false-d879186e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('ORG') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'ORG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(TransmissionWrapperDevice): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(TransmissionWrapperDevice): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[not(@nullFlavor)])&lt;=1">(TransmissionWrapperDevice): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:NotificationParty)&lt;=1">(TransmissionWrapperDevice): element hl7:NotificationParty komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:id[not(@nullFlavor)]
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:id[not(@nullFlavor)]" id="d879068e38-false-d879237e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:name
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:name" id="d879068e41-false-d879250e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:telecom
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:telecom" id="d879068e44-false-d879263e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty" id="d879068e47-false-d879277e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('CON') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'CON' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:contactParty)&gt;=1">(TransmissionWrapperDevice): element hl7:contactParty is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:contactParty)&lt;=1">(TransmissionWrapperDevice): element hl7:contactParty komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:id
Item: (COCT_MT040203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:id" id="d879283e18-false-d879326e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:code
Item: (COCT_MT040203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:code" id="d879283e19-false-d879339e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:addr
Item: (COCT_MT040203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:addr" id="d879283e20-false-d879352e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:telecom
Item: (COCT_MT040203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:telecom" id="d879283e21-false-d879365e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty
Item: (COCT_MT040203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty" id="d879283e22-false-d879378e0">
        <let name="elmcount" value="count(hl7:Organization|hl7:Person)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="$elmcount&gt;=1">(COCT_MT040203): keuze (hl7:Organization of hl7:Person) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="$elmcount&lt;=1">(COCT_MT040203): keuze (hl7:Organization of hl7:Person) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="count(hl7:Organization)&lt;=1">(COCT_MT040203): element hl7:Organization komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="count(hl7:Person)&lt;=1">(COCT_MT040203): element hl7:Person komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization
Item: (COCT_MT040203)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('ORG') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'ORG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT150003): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:id)&gt;=1">(COCT_MT150003): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:code)&lt;=1">(COCT_MT150003): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:contact)&gt;=1">(COCT_MT150003): element hl7:contact is required [min 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:id
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:code
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:name
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:name">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('CON') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'CON' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:code)&lt;=1">(COCT_MT150003): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:contactPerson)&lt;=1">(COCT_MT150003): element hl7:contactPerson komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:id
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:code
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:addr
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:telecom
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson">
        <extends rule="d879602e22-false-d880296e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT150003): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:name)&gt;=1">(COCT_MT150003): element hl7:name is required [min 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name">
        <extends rule="d880282e21-false-d880371e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId">
        <extends rule="d880282e31-false-d880530e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson
Item: (COCT_MT030203)
-->
    <rule id="d879602e22-false-d880296e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT030203): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT030203): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:id)&gt;=1">(COCT_MT030203): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:administrativeGenderCode)&lt;=1">(COCT_MT030203): element hl7:administrativeGenderCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:birthTime)&lt;=1">(COCT_MT030203): element hl7:birthTime komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:id
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name
Item: (COCT_MT030203)
-->
    <rule id="d880282e21-false-d880371e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:administrativeGenderCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:administrativeGenderCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:birthTime
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:birthTime">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="not(*)">(COCT_MT030203): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:languageCode)&lt;=1">(COCT_MT030203): element hl7:languageCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:modeCode)&lt;=1">(COCT_MT030203): element hl7:modeCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:proficiencyLevelCode)&lt;=1">(COCT_MT030203): element hl7:proficiencyLevelCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:preferenceInd)&lt;=1">(COCT_MT030203): element hl7:preferenceInd komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:languageCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:languageCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:modeCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:modeCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:proficiencyLevelCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:preferenceInd
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:preferenceInd">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="BL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule id="d880282e31-false-d880530e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person
Item: (COCT_MT040203)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT030203): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT030203): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:id)&gt;=1">(COCT_MT030203): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:administrativeGenderCode)&lt;=1">(COCT_MT030203): element hl7:administrativeGenderCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:birthTime)&lt;=1">(COCT_MT030203): element hl7:birthTime komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:id
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:name
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:name">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:administrativeGenderCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:administrativeGenderCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:birthTime
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:birthTime">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="not(*)">(COCT_MT030203): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:languageCode)&lt;=1">(COCT_MT030203): element hl7:languageCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:modeCode)&lt;=1">(COCT_MT030203): element hl7:modeCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:proficiencyLevelCode)&lt;=1">(COCT_MT030203): element hl7:proficiencyLevelCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:preferenceInd)&lt;=1">(COCT_MT030203): element hl7:preferenceInd komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:languageCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:languageCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:modeCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:modeCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:proficiencyLevelCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:preferenceInd
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:preferenceInd">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="BL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.3
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess
Item: (MFMI_ActCategoryReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess" id="d880869e24-false-d880880e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="string(@moodCode)=('EVN')">(MFMI_ActCategoryReference): de waarde van @moodCode MOET 'EVN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not(@moodCode) or (string-length(@moodCode)&gt;0 and not(matches(@moodCode,'\s')))">(MFMI_ActCategoryReference): attribuut @moodCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="count(hl7:code)&lt;=1">(MFMI_ActCategoryReference): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="count(hl7:effectiveTime)&lt;=1">(MFMI_ActCategoryReference): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="count(hl7:authorOrPerformer[not(@nullFlavor)])&gt;=1">(MFMI_ActCategoryReference): element hl7:authorOrPerformer[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="count(hl7:authorOrPerformer[not(@nullFlavor)])&lt;=1">(MFMI_ActCategoryReference): element hl7:authorOrPerformer[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="count(hl7:overseer)&lt;=1">(MFMI_ActCategoryReference): element hl7:overseer komt te vaak voor [max 1x].</assert>
        <let name="controlActProcess" value="."/>
        <let name="authorEntity" value="$controlActProcess/hl7:authorOrPerformer//hl7:*[lower-case(local-name())=('assigneddevice','assignedperson')][1]"/>
        <let name="authorDevice" value="$authorEntity[lower-case(local-name())='assigneddevice']"/>
        <let name="authorPerson" value="$authorEntity[lower-case(local-name())='assignedperson']"/>
        <let name="overseerPerson" value="$controlActProcess/hl7:overseer//hl7:*[lower-case(local-name())=('assignedentity','assignedperson')][1]"/>
        <let name="authorPath" value="string-join($authorEntity/ancestor-or-self::*/name(),'/')"/>
        <let name="overseerPath" value="string-join($overseerPerson/ancestor-or-self::*/name(),'/')"/>
        <let name="senderApplicationId" value="$controlActProcess/../hl7:sender/hl7:device/hl7:id[@root='2.16.840.1.113883.2.4.6.6']/@extension"/>
        <let name="authorApplicationId" value="$authorDevice/hl7:id[@root='2.16.840.1.113883.2.4.6.6']/@extension"/>
        <let name="overseerOrgId" value="$overseerPerson/hl7:Organization/hl7:id"/>
        <let name="authorOrgId" value="$authorEntity/hl7:Organization/hl7:id"/>
        <let name="interactionId" value="$controlActProcess/../local-name()"/>
        <let name="interactionVocabFile" value="'../vocab/2.16.840.1.113883.1.6.xml'"/>
        <let name="interactionVocab" value="if (doc-available($interactionVocabFile)) then doc($interactionVocabFile) else ()"/>
        <let name="interactionTrustLevel" value="$interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Vertrouwensniveau']/@value"/>
        <let name="interactionSendType" value="$interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Verzendtype']/@value"/>
        <let name="interactionTriggerEventCode" value="$interactionVocab/*/hl7:code[@code=$interactionId]/hl7:reference/@extension"/>
        <let name="messageTriggerEventCode" value="$controlActProcess/hl7:code/@code"/>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="$interactionVocab">(MFMI_ActCategoryReference): Control Act: <value-of select="$interactionVocabFile"/> niet gevonden. Controles gebaseerd op dit externe configuratiebestand zijn gedeactiveerd.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($controlActProcess/hl7:queryByParameter) or $controlActProcess[@moodCode='EVN']">(MFMI_ActCategoryReference): Control Act: <value-of select="local-name()"/>/@moodCode moet 'EVN' zijn bij queries</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($interactionVocab) or not($messageTriggerEventCode) or $interactionTriggerEventCode=$messageTriggerEventCode">(MFMI_ActCategoryReference): Control Act: <value-of select="local-name()"/>/code (Trigger Event) moet bij deze interactie '<value-of select="$interactionTriggerEventCode"/>' zijn, gevonden is echter '<value-of select="$messageTriggerEventCode"/>'</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($interactionVocab) or $authorPerson or not($interactionTrustLevel) or $interactionTrustLevel='Laag'">(MFMI_ActCategoryReference): Control Act: <value-of select="local-name()"/>/authorOrPerformer moet een persoon bevatten in berichten met vertrouwensniveau midden of hoog</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($interactionVocab) or $overseerPerson or empty($interactionTrustLevel) or $interactionTrustLevel='Laag'">(MFMI_ActCategoryReference): Control Act: <value-of select="local-name()"/>/overseer moet de mandaterende persoon bevatten in berichten met vertrouwensniveau midden of hoog</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($authorEntity//hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or not($authorEntity/../(hl7:queryByParameter|hl7:subject)//hl7:*[@root='2.16.840.1.113883.2.4.6.3']) or $authorEntity/../../hl7:attentionLine">(MFMI_ActCategoryReference): Patiëntgebonden interacties, verzonden vanuit een patiëntenportaal (GBP), moeten een attentionLine hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($authorEntity//hl7:id[@root=('2.16.840.1.113883.2.4.3.11.7.3','2.16.528.1.1003.1.3.5.4.1')]) or not($authorEntity/../(hl7:queryByParameter|hl7:subject)//hl7:*[@root='2.16.840.1.113883.2.4.6.3']) or $authorEntity/../../hl7:attentionLine">(MFMI_ActCategoryReference): Patiëntgebonden interacties, verzonden vanuit het klantenloket (GBK), moeten een attentionLine hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="empty($senderApplicationId) or empty($authorApplicationId) or $senderApplicationId=$authorApplicationId or $senderApplicationId='1'">(MFMI_ActCategoryReference): Control Act: <value-of select="$authorPath"/>/id. Applicatie-id <value-of select="$authorApplicationId"/> komt niet overeen met Transmission-wrapper sender <value-of select="$senderApplicationId"/>.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($authorDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']) or $authorDevice/hl7:id[@root='2.16.528.1.1007.3.2']">(MFMI_ActCategoryReference): Control Act: <value-of select="$authorPath"/>/id moet tenminste het UZI-nummer systemen bevatten voor een XIS in een GBZ</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($authorDevice/hl7:id[@root='2.16.528.1.1007.3.2']) or $authorDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3' and @extension]">(MFMI_ActCategoryReference): Control Act: <value-of select="$authorPath"/>/id moet de zorgaanbieder van het XIS identificeren</assert>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($authorDevice) or $authorDevice/hl7:id[@root='2.16.840.1.113883.2.4.6.6'][@extension='1'] or $authorDevice/hl7:id[@root='2.16.528.1.1007.4'] or $authorDevice/hl7:Organization/hl7:id">(MFMI_ActCategoryReference): Control Act: <value-of select="$authorPath"/>/ moet een geïdentificeerde organisatie hebben, tenzij het de ZIM of het SBV-Z betreft.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($authorPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or $authorPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='P']">(MFMI_ActCategoryReference): Control Act: <value-of select="$authorPath"/>/code/@code moet "P" (Patiënt) zijn. Wettelijke vertegenwoordigers moet dit via het Klantenloket doen en kunnen dus niet als auteur optreden</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($authorPerson/hl7:id[@root=('2.16.840.1.113883.2.4.3.11.7.3','2.16.528.1.1003.1.3.5.4.1')]) or $authorPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='KLANTENLOKET']">(MFMI_ActCategoryReference): Control Act: <value-of select="$authorPath"/>/code/@code moet "KLANTENLOKET" zijn voor klantenloketmedewerkers</assert>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($authorPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $authorPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']">(MFMI_ActCategoryReference): Control Act: <value-of select="$authorPath"/>/code ontbreekt. Dit is alleen toegestaan als de rolcode 00.000 is.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($authorPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $authorOrgId[@root='2.16.528.1.1007.3.3' and @extension]">(MFMI_ActCategoryReference): Control Act: <value-of select="$authorPath"/>/Organization/id moet de zorgaanbieder van de persoon identificeren</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($authorPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or $authorOrgId[@root='2.16.840.1.113883.2.4.3.11.25']">(MFMI_ActCategoryReference): Control Act: <value-of select="$authorPath"/>/Organization/id/@root moet '2.16.840.1.113883.2.4.3.11.25' bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($authorPerson/hl7:id[@root=('2.16.840.1.113883.2.4.3.11','2.16.528.1.1003.1.3.5.4.1')]) or $authorOrgId[@root='2.16.840.1.113883.2.4.3.11'][@extension='7']">(MFMI_ActCategoryReference): Control Act: <value-of select="$authorPath"/>/Organization/id moet de Nictiz-klantenloket organisatie identificeren</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($overseerPerson/hl7:Organization[not(hl7:name)]/hl7:id[@root='2.16.528.1.1007.3.3'])">(MFMI_ActCategoryReference): Control Act: <value-of select="$authorPath"/>/Organization/name moet de zorgaanbieder/organisatienaam bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($overseerPerson/hl7:Organization[not(hl7:name)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11' and @extension='7'])">(MFMI_ActCategoryReference): Control Act: <value-of select="$authorPath"/>/Organization/name moet de Nictiz-klantenloket organisatienaam bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($overseerPerson) or $overseerPerson/hl7:code">(MFMI_ActCategoryReference): Control Act: <value-of select="$overseerPath"/>/code is verplicht</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($overseerPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or $overseerPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='P'] or $overseerPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.6']">(MFMI_ActCategoryReference): Control Act: <value-of select="$overseerPath"/>/code/@code moet "P" (Patiënt) zijn of een geldige waarde uit RoleCodeWettelijkeVertegenwoordigerNL</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($overseerPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $overseerPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson/hl7:name">(MFMI_ActCategoryReference): Control Act: <value-of select="$overseerPath"/>/assignedPrincipalChoiceList/assignedPerson/name is verplicht</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($overseerPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $overseerPerson/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']">(MFMI_ActCategoryReference): Control Act: <value-of select="$overseerPath"/>/Organization/id moet de zorgaanbieder van de persoon identificeren</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($overseerPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $overseerPerson/hl7:Organization/hl7:name">(MFMI_ActCategoryReference): Control Act: <value-of select="$overseerPath"/>//Organization/name moet de zorgaanbiedernaam bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($overseerPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $overseerPerson/hl7:Organization/hl7:addr/hl7:city">(MFMI_ActCategoryReference): Control Act: <value-of select="$overseerPath"/>/Organization/addr moet tennminste de vestigingsplaats bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not($overseerOrgId) or $authorOrgId[@root=$overseerOrgId/@root][@extension=$overseerOrgId/@extension] or $authorEntity[lower-case(local-name())='assigneddevice']">(MFMI_ActCategoryReference): Control Act: <value-of select="$overseerPath"/>/Organization/id. Organisatie van de overseer (<value-of select="$overseerOrgId/@root"/>#<value-of select="$overseerOrgId/@extension"/>) moet gelijk zijn aan die van de authorOrPerformer (<value-of select="$authorOrgId/@extension"/>)</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.3
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:code
Item: (MFMI_ActCategoryReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:code" id="d880869e26-false-d880957e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MFMI_ActCategoryReference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="@nullFlavor or (@codeSystem='2.16.840.1.113883.1.18')">(MFMI_ActCategoryReference): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.1.18''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.3
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:effectiveTime
Item: (MFMI_ActCategoryReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:effectiveTime" id="d880869e30-false-d880976e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MFMI_ActCategoryReference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not(*)">(MFMI_ActCategoryReference): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.500
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer
Item: (ControlActAuthorOrPerformer)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer" id="d880977e57-false-d880992e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="@typeCode">(ControlActAuthorOrPerformer): attribute @typeCode MOET aanwezig zijn.</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@typeCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.19080-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="not(@typeCode) or count($theAttValue) = count($theAttCheck)">(ControlActAuthorOrPerformer): de waarde van typeCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.19080' x_ParticipationAuthorPerformer (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="count(hl7:participant[not(@nullFlavor)])&gt;=1">(ControlActAuthorOrPerformer): element hl7:participant[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="count(hl7:participant[not(@nullFlavor)])&lt;=1">(ControlActAuthorOrPerformer): element hl7:participant[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.500
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]
Item: (ControlActAuthorOrPerformer)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]" id="d880977e64-false-d881028e0">
        <let name="elmcount" value="count(hl7:AssignedDevice|hl7:AssignedPerson)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="$elmcount&gt;=1">(ControlActAuthorOrPerformer): keuze (hl7:AssignedDevice of hl7:AssignedPerson) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="$elmcount&lt;=1">(ControlActAuthorOrPerformer): keuze (hl7:AssignedDevice of hl7:AssignedPerson) bevat te veel elementen [max 1x]</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.500
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice
Item: (ControlActAuthorOrPerformer)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice
Item: (COCT_MT090300)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.2']|hl7:id[@root='2.16.840.1.113883.2.4.6.6']|hl7:id[@root='2.16.528.1.1007.4'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="$elmcount&gt;=1">(COCT_MT090300): keuze (hl7:id[@root='2.16.528.1.1007.3.2'] of hl7:id[@root='2.16.840.1.113883.2.4.6.6'] of hl7:id[@root='2.16.528.1.1007.4']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="$elmcount&lt;=2">(COCT_MT090300): keuze (hl7:id[@root='2.16.528.1.1007.3.2'] of hl7:id[@root='2.16.840.1.113883.2.4.6.6'] of hl7:id[@root='2.16.528.1.1007.4']) bevat te veel elementen [max 2x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:Organization)&lt;=1">(COCT_MT090300): element hl7:Organization komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1010
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.528.1.1007.3.2']
Item: (dtUZIsystemen)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.528.1.1007.3.2']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1010" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtUZIsystemen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.UZI"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1010" test="string(@root)=('2.16.528.1.1007.3.2')">(dtUZIsystemen): de waarde van @root MOET '2.16.528.1.1007.3.2' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1008
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.840.1.113883.2.4.6.6']
Item: (dtAortaApplicationId)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.840.1.113883.2.4.6.6']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1008" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtAortaApplicationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1008" test="string(@root)=('2.16.840.1.113883.2.4.6.6')">(dtAortaApplicationId): de waarde van @root MOET '2.16.840.1.113883.2.4.6.6' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1018
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.528.1.1007.4']
Item: (dtSBV-Zsystemen)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.528.1.1007.4']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1018" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtSBV-Zsystemen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1018" test="string(@root)=('2.16.528.1.1007.4')">(dtSBV-Zsystemen): de waarde van @root MOET '2.16.528.1.1007.4' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization
Item: (COCT_MT090300)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id[@root='2.16.528.1.1007']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']|hl7:id[@root='2.16.840.1.113883.2.4.3.11'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="$elmcount&gt;=1">(COCT_MT090300): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="$elmcount&lt;=1">(COCT_MT090300): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:code)&lt;=1">(COCT_MT090300): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090300): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090300): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:addr)&lt;=1">(COCT_MT090300): element hl7:addr komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1011
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (dtURAorganization)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtURAorganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.URA"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="string(@root)=('2.16.528.1.1007.3.3')">(dtURAorganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1019
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007']
Item: (dtSBV-ZOrganizationId)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtSBV-ZOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@root)=('2.16.528.1.1007')">(dtSBV-ZOrganizationId): de waarde van @root MOET '2.16.528.1.1007' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@extension)=('4')">(dtSBV-ZOrganizationId): de waarde van @extension MOET '4' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1020
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']
Item: (dtGBO-GBP)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBO-GBP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="string(@root)=('2.16.840.1.113883.2.4.3.11.25')">(dtGBO-GBP): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.25' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1021
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11']
Item: (dtGBKOrganizationId)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBKOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@root)=('2.16.840.1.113883.2.4.3.11')">(dtGBKOrganizationId): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@extension)=('7')">(dtGBKOrganizationId): de waarde van @extension MOET '7' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id
Item: (COCT_MT090300)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:code
Item: (COCT_MT090300)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090300): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.1 RoleCodeNL - zorgaanbiedertype (organisaties) (DYNAMISCH)'.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:telecom
Item: (COCT_MT090300)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090300)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:addr
Item: (COCT_MT090300)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:city[not(@nullFlavor)])&gt;=1">(COCT_MT090300): element hl7:city[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:city[not(@nullFlavor)])&lt;=1">(COCT_MT090300): element hl7:city[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:addr/hl7:city[not(@nullFlavor)]
Item: (COCT_MT090300)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:templateId
Item: (COCT_MT090300)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.500
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson
Item: (ControlActAuthorOrPerformer)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id[@root='2.16.840.1.113883.2.4.6.3']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']|hl7:id[@root='2.16.528.1.1003.1.3.5.4.1'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&gt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id[@root='2.16.840.1.113883.2.4.6.3'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3'] of hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&lt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id[@root='2.16.840.1.113883.2.4.6.3'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3'] of hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.1'])&lt;=1">(COCT_MT090100): element hl7:id[@root='2.16.840.1.113883.2.4.6.1'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:code)&lt;=1">(COCT_MT090100): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:telecom)&lt;=1">(COCT_MT090100): element hl7:telecom komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPrincipalChoiceList)&lt;=1">(COCT_MT090100): element hl7:assignedPrincipalChoiceList komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:Organization[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:Organization[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:Organization[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:Organization[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1009
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.528.1.1007.3.1']
Item: (dtUZIpersonen)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.528.1.1007.3.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1009" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtUZIpersonen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.UZI"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1009" test="string(@root)=('2.16.528.1.1007.3.1')">(dtUZIpersonen): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1012
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']
Item: (dtBSN)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtBSN): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.BSN"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="string(@root)=('2.16.840.1.113883.2.4.6.3')">(dtBSN): de waarde van @root MOET '2.16.840.1.113883.2.4.6.3' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$')">(dtBSN): attribuut @root MOET datatype 'oid' hebben</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1015
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']
Item: (dtBatchInzageAuteur)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1015" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtBatchInzageAuteur): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1015" test="string(@root)=('2.16.840.1.113883.2.4.3.11.7.3')">(dtBatchInzageAuteur): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.7.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1016
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']
Item: (dtNictizKlantenloketPKIO)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1016" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtNictizKlantenloketPKIO): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1016" test="string(@root)=('2.16.528.1.1003.1.3.5.4.1')">(dtNictizKlantenloketPKIO): de waarde van @root MOET '2.16.528.1.1003.1.3.5.4.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1017
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.1']
Item: (dtAGB)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1017" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtAGB): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.AGB"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1017" test="string(@root)=('2.16.840.1.113883.2.4.6.1')">(dtAGB): de waarde van @root MOET '2.16.840.1.113883.2.4.6.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:code
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.4-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.5-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090100): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.2 RoleCodeNL - zorgverlenertype (personen) (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.102.11.4 RoleCodeNL - toegang patiënt (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.102.11.5 RoleCodeNL - wettelijke vertegenwoording (DYNAMISCH)'.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="not(@code='00.000' and @codeSystem='2.16.840.1.113883.2.4.15.111')">(COCT_MT090100): Control Act: <name path=".."/>/<name/> moet een UZI-rolcode 00.000 is niet toegestaan</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:telecom
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPerson[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:assignedPerson[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPerson[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:assignedPerson[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id[@root='2.16.528.1.1007']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']|hl7:id[@root='2.16.840.1.113883.2.4.3.11'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&gt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&lt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:code)&lt;=1">(COCT_MT090100): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:addr)&lt;=1">(COCT_MT090100): element hl7:addr komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1011
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (dtURAorganization)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtURAorganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.URA"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="string(@root)=('2.16.528.1.1007.3.3')">(dtURAorganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1019
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007']
Item: (dtSBV-ZOrganizationId)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtSBV-ZOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@root)=('2.16.528.1.1007')">(dtSBV-ZOrganizationId): de waarde van @root MOET '2.16.528.1.1007' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@extension)=('4')">(dtSBV-ZOrganizationId): de waarde van @extension MOET '4' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1020
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']
Item: (dtGBO-GBP)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBO-GBP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="string(@root)=('2.16.840.1.113883.2.4.3.11.25')">(dtGBO-GBP): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.25' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1021
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11']
Item: (dtGBKOrganizationId)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBKOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@root)=('2.16.840.1.113883.2.4.3.11')">(dtGBKOrganizationId): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@extension)=('7')">(dtGBKOrganizationId): de waarde van @extension MOET '7' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:code
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090100): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.1 RoleCodeNL - zorgaanbiedertype (organisaties) (DYNAMISCH)'.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:telecom
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:addr
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:city)&lt;=1">(COCT_MT090100): element hl7:city komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:addr/hl7:city
Item: (COCT_MT090100)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:templateId
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.502
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer
Item: (ControlActOverseerPersonMcaiMfmi)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer" id="d882120e40-false-d882133e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.502" test="string(@typeCode)=('RESP')">(ControlActOverseerPersonMcaiMfmi): de waarde van @typeCode MOET 'RESP' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.502
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]
Item: (ControlActOverseerPersonMcaiMfmi)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id[@root='2.16.840.1.113883.2.4.6.3']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']|hl7:id[@root='2.16.528.1.1003.1.3.5.4.1'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&gt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id[@root='2.16.840.1.113883.2.4.6.3'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3'] of hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&lt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id[@root='2.16.840.1.113883.2.4.6.3'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3'] of hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.1'])&lt;=1">(COCT_MT090100): element hl7:id[@root='2.16.840.1.113883.2.4.6.1'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:code)&lt;=1">(COCT_MT090100): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:telecom)&lt;=1">(COCT_MT090100): element hl7:telecom komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPrincipalChoiceList)&lt;=1">(COCT_MT090100): element hl7:assignedPrincipalChoiceList komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:Organization[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:Organization[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:Organization[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:Organization[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1009
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.1']
Item: (dtUZIpersonen)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1009" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtUZIpersonen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.UZI"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1009" test="string(@root)=('2.16.528.1.1007.3.1')">(dtUZIpersonen): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1012
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.3']
Item: (dtBSN)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtBSN): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.BSN"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="string(@root)=('2.16.840.1.113883.2.4.6.3')">(dtBSN): de waarde van @root MOET '2.16.840.1.113883.2.4.6.3' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$')">(dtBSN): attribuut @root MOET datatype 'oid' hebben</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1015
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']
Item: (dtBatchInzageAuteur)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1015" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtBatchInzageAuteur): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1015" test="string(@root)=('2.16.840.1.113883.2.4.3.11.7.3')">(dtBatchInzageAuteur): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.7.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1016
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']
Item: (dtNictizKlantenloketPKIO)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1016" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtNictizKlantenloketPKIO): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1016" test="string(@root)=('2.16.528.1.1003.1.3.5.4.1')">(dtNictizKlantenloketPKIO): de waarde van @root MOET '2.16.528.1.1003.1.3.5.4.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1017
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.1']
Item: (dtAGB)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1017" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtAGB): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.AGB"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1017" test="string(@root)=('2.16.840.1.113883.2.4.6.1')">(dtAGB): de waarde van @root MOET '2.16.840.1.113883.2.4.6.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:code
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.4-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.5-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090100): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.2 RoleCodeNL - zorgverlenertype (personen) (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.102.11.4 RoleCodeNL - toegang patiënt (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.102.11.5 RoleCodeNL - wettelijke vertegenwoording (DYNAMISCH)'.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="not(@code='00.000' and @codeSystem='2.16.840.1.113883.2.4.15.111')">(COCT_MT090100): Control Act: <name path=".."/>/<name/> moet een UZI-rolcode 00.000 is niet toegestaan</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:telecom
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPerson[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:assignedPerson[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPerson[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:assignedPerson[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id[@root='2.16.528.1.1007']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']|hl7:id[@root='2.16.840.1.113883.2.4.3.11'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&gt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&lt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:code)&lt;=1">(COCT_MT090100): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:addr)&lt;=1">(COCT_MT090100): element hl7:addr komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1011
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (dtURAorganization)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtURAorganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.URA"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="string(@root)=('2.16.528.1.1007.3.3')">(dtURAorganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1019
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007']
Item: (dtSBV-ZOrganizationId)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtSBV-ZOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@root)=('2.16.528.1.1007')">(dtSBV-ZOrganizationId): de waarde van @root MOET '2.16.528.1.1007' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@extension)=('4')">(dtSBV-ZOrganizationId): de waarde van @extension MOET '4' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1020
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']
Item: (dtGBO-GBP)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBO-GBP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="string(@root)=('2.16.840.1.113883.2.4.3.11.25')">(dtGBO-GBP): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.25' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1021
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11']
Item: (dtGBKOrganizationId)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBKOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@root)=('2.16.840.1.113883.2.4.3.11')">(dtGBKOrganizationId): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@extension)=('7')">(dtGBKOrganizationId): de waarde van @extension MOET '7' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:code
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090100): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.1 RoleCodeNL - zorgaanbiedertype (organisaties) (DYNAMISCH)'.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:telecom
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:addr
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:city)&lt;=1">(COCT_MT090100): element hl7:city komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:addr/hl7:city
Item: (COCT_MT090100)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:templateId
Item: (COCT_MT090100)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.3
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]
Item: (MFMI_ActCategoryReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]" id="d880869e48-false-d882800e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="string(@typeCode)=('SUBJ') or not(@typeCode)">(MFMI_ActCategoryReference): de waarde van @typeCode MOET 'SUBJ' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not(@typeCode) or (string-length(@typeCode)&gt;0 and not(matches(@typeCode,'\s')))">(MFMI_ActCategoryReference): attribuut @typeCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="string(@contextConductionInd)=('false') or not(@contextConductionInd)">(MFMI_ActCategoryReference): de waarde van @contextConductionInd MOET 'false' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="not(@contextConductionInd) or string(@contextConductionInd)=('true','false')">(MFMI_ActCategoryReference): attribuut @contextConductionInd MOET datatype 'bl' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="count(hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]])&gt;=1">(MFMI_ActCategoryReference): element hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]] is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.3" test="count(hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]])&lt;=1">(MFMI_ActCategoryReference): element hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.4
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]
Item: (RegistrationEventACT_ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]" id="d882817e21-false-d882844e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="string(@classCode)=('REG') or not(@classCode)">(RegistrationEventACT_ActReference): de waarde van @classCode MOET 'REG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="not(@classCode) or (string-length(@classCode)&gt;0 and not(matches(@classCode,'\s')))">(RegistrationEventACT_ActReference): attribuut @classCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="@moodCode">(RegistrationEventACT_ActReference): attribute @moodCode MOET aanwezig zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="not(@moodCode) or (string-length(@moodCode)&gt;0 and not(matches(@moodCode,'\s')))">(RegistrationEventACT_ActReference): attribuut @moodCode MOET datatype 'cs' hebben</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@moodCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.10196-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="not(@moodCode) or count($theAttValue) = count($theAttCheck)">(RegistrationEventACT_ActReference): de waarde van moodCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.10196' ActMood (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)])&gt;=1">(RegistrationEventACT_ActReference): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)])&lt;=1">(RegistrationEventACT_ActReference): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="count(hl7:statusCode[@code=doc('include/voc-2.16.840.1.113883.1.11.159331-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)])&gt;=1">(RegistrationEventACT_ActReference): element hl7:statusCode[@code=doc('include/voc-2.16.840.1.113883.1.11.159331-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="count(hl7:statusCode[@code=doc('include/voc-2.16.840.1.113883.1.11.159331-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)])&lt;=1">(RegistrationEventACT_ActReference): element hl7:statusCode[@code=doc('include/voc-2.16.840.1.113883.1.11.159331-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="count(hl7:effectiveTime)&gt;=1">(RegistrationEventACT_ActReference): element hl7:effectiveTime is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="count(hl7:effectiveTime)&lt;=1">(RegistrationEventACT_ActReference): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="count(hl7:subject1)=0">(RegistrationEventACT_ActReference): element hl7:subject1 MAG NIET voorkomen.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.4
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:id
Item: (RegistrationEventACT_ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:id" id="d882817e25-false-d882940e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(RegistrationEventACT_ActReference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <let name="sendingId" value="string-join(../../../../hl7:sender/hl7:device/hl7:id/(@root|@extension),'#')"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="$sendingId='2.16.840.1.113883.2.4.6.6#1' or @nullFlavor='UNK'">(RegistrationEventACT_ActReference): Control Act: registrationProcess/id/@nullFlavor moet 'UNK' zijn tenzij de afzender de ZIM is</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="not($sendingId='2.16.840.1.113883.2.4.6.6#1') or @root">(RegistrationEventACT_ActReference): Control Act: registrationProcess/id moet een waarde hebben als de afzender de ZIM is</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.4
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]
Item: (RegistrationEventACT_ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]" id="d882817e31-false-d882955e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(RegistrationEventACT_ActReference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CD"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(RegistrationEventACT_ActReference): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.102.11.8 ActRegistryCode: x_DataDomainNL (DYNAMISCH)'.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.4
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:statusCode[@code=doc('include/voc-2.16.840.1.113883.1.11.159331-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)]
Item: (RegistrationEventACT_ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:statusCode[@code=doc('include/voc-2.16.840.1.113883.1.11.159331-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code][not(@nullFlavor)]" id="d882817e36-false-d882981e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(RegistrationEventACT_ActReference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.159331-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(RegistrationEventACT_ActReference): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.159331 ActStatus (DYNAMISCH)'.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.4
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:effectiveTime
Item: (RegistrationEventACT_ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:effectiveTime" id="d882817e41-false-d883005e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(RegistrationEventACT_ActReference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="IVL_TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="not(@value)">(RegistrationEventACT_ActReference): attribute @value MAG NIET voorkomen.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="string(@nullFlavor)=('UNK') or not(@nullFlavor)">(RegistrationEventACT_ActReference): de waarde van @nullFlavor MOET 'UNK' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="not(@nullFlavor) or (string-length(@nullFlavor)&gt;0 and not(matches(@nullFlavor,'\s')))">(RegistrationEventACT_ActReference): attribuut @nullFlavor MOET datatype 'cs' hebben</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.4
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:effectiveTime/hl7:low
Item: (RegistrationEventACT_ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:effectiveTime/hl7:low" id="d882817e44-false-d883041e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="string(@nullFlavor)=('UNK') or not(@nullFlavor)">(RegistrationEventACT_ActReference): de waarde van @nullFlavor MOET 'UNK' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="not(@nullFlavor) or (string-length(@nullFlavor)&gt;0 and not(matches(@nullFlavor,'\s')))">(RegistrationEventACT_ActReference): attribuut @nullFlavor MOET datatype 'cs' hebben</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.4
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:effectiveTime/hl7:high
Item: (RegistrationEventACT_ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:effectiveTime/hl7:high" id="d882817e48-false-d883057e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="string(@nullFlavor)=('UNK') or not(@nullFlavor)">(RegistrationEventACT_ActReference): de waarde van @nullFlavor MOET 'UNK' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="not(@nullFlavor) or (string-length(@nullFlavor)&gt;0 and not(matches(@nullFlavor,'\s')))">(RegistrationEventACT_ActReference): attribuut @nullFlavor MOET datatype 'cs' hebben</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.4
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject1
Item: (RegistrationEventACT_ActReference)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.4
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2
Item: (RegistrationEventACT_ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2" id="d882817e53-false-d883084e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="string(@typeCode)=('SUBJ') or not(@typeCode)">(RegistrationEventACT_ActReference): de waarde van @typeCode MOET 'SUBJ' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.4" test="not(@typeCode) or (string-length(@typeCode)&gt;0 and not(matches(@typeCode,'\s')))">(RegistrationEventACT_ActReference): attribuut @typeCode MOET datatype 'cs' hebben</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.27
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]
Item: (ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]" id="d883094e12-false-d883110e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="string(@classCode)=('CATEGORY') or not(@classCode)">(ActReference): de waarde van @classCode MOET 'CATEGORY' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="not(@classCode) or (string-length(@classCode)&gt;0 and not(matches(@classCode,'\s')))">(ActReference): attribuut @classCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="string(@moodCode)=('EVN') or not(@moodCode)">(ActReference): de waarde van @moodCode MOET 'EVN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="not(@moodCode) or (string-length(@moodCode)&gt;0 and not(matches(@moodCode,'\s')))">(ActReference): attribuut @moodCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:recordTarget[not(@nullFlavor)])&gt;=1">(ActReference): element hl7:recordTarget[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:recordTarget[not(@nullFlavor)])&lt;=1">(ActReference): element hl7:recordTarget[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:custodian[not(@nullFlavor)])&gt;=1">(ActReference): element hl7:custodian[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:custodian[not(@nullFlavor)])&lt;=1">(ActReference): element hl7:custodian[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:subjectOf)&lt;=1">(ActReference): element hl7:subjectOf komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.27
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:recordTarget[not(@nullFlavor)]
Item: (ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:recordTarget[not(@nullFlavor)]" id="d883094e15-false-d883166e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="string(@typeCode)=('RCT') or not(@typeCode)">(ActReference): de waarde van @typeCode MOET 'RCT' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="not(@typeCode) or (string-length(@typeCode)&gt;0 and not(matches(@typeCode,'\s')))">(ActReference): attribuut @typeCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:patient[not(@nullFlavor)])&gt;=1">(ActReference): element hl7:patient[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:patient[not(@nullFlavor)])&lt;=1">(ActReference): element hl7:patient[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.27
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:recordTarget[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]
Item: (ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:recordTarget[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]" id="d883094e17-false-d883194e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.3'])&gt;=1">(ActReference): element hl7:id[@root='2.16.840.1.113883.2.4.6.3'] is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.3'])&lt;=1">(ActReference): element hl7:id[@root='2.16.840.1.113883.2.4.6.3'] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.27
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:recordTarget[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.3']
Item: (ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:recordTarget[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.3']" id="d883094e20-false-d883216e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="string(@root)=('2.16.840.1.113883.2.4.6.3')">(ActReference): de waarde van @root MOET '2.16.840.1.113883.2.4.6.3' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="not(@root) or (string-length(@root)&gt;0 and not(matches(@root,'\s')))">(ActReference): attribuut @root MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="@extension">(ActReference): attribute @extension MOET aanwezig zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="not(@extension) or (string-length(@extension)&gt;0 and not(matches(@extension,'\s')))">(ActReference): attribuut @extension MOET datatype 'cs' hebben</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.27
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:custodian[not(@nullFlavor)]
Item: (ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:custodian[not(@nullFlavor)]" id="d883094e23-false-d883239e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="string(@typeCode)=('CST') or not(@typeCode)">(ActReference): de waarde van @typeCode MOET 'CST' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="not(@typeCode) or (string-length(@typeCode)&gt;0 and not(matches(@typeCode,'\s')))">(ActReference): attribuut @typeCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:assignedOrganization[not(@nullFlavor)])&gt;=1">(ActReference): element hl7:assignedOrganization[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:assignedOrganization[not(@nullFlavor)])&lt;=1">(ActReference): element hl7:assignedOrganization[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.27
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:custodian[not(@nullFlavor)]/hl7:assignedOrganization[not(@nullFlavor)]
Item: (ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:custodian[not(@nullFlavor)]/hl7:assignedOrganization[not(@nullFlavor)]" id="d883094e27-false-d883267e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="string(@classCode)=('ASSIGNED') or not(@classCode)">(ActReference): de waarde van @classCode MOET 'ASSIGNED' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="not(@classCode) or (string-length(@classCode)&gt;0 and not(matches(@classCode,'\s')))">(ActReference): attribuut @classCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(ActReference): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:id[not(@nullFlavor)])&lt;=1">(ActReference): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:telecom[not(@nullFlavor)])&gt;=1">(ActReference): element hl7:telecom[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:telecom[not(@nullFlavor)])&lt;=1">(ActReference): element hl7:telecom[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.27
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:custodian[not(@nullFlavor)]/hl7:assignedOrganization[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:custodian[not(@nullFlavor)]/hl7:assignedOrganization[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]" id="d883094e31-false-d883307e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ActReference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="string(@root)=('2.16.528.1.1007.3.3') or not(@root)">(ActReference): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(ActReference): attribuut @root MOET datatype 'uid' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="not(@extension) or matches(@extension,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@extension,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@extension,'^[A-Za-z][A-Za-z\d\-]*$')">(ActReference): attribuut @extension MOET datatype 'uid' hebben</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.27
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:custodian[not(@nullFlavor)]/hl7:assignedOrganization[not(@nullFlavor)]/hl7:telecom[not(@nullFlavor)]
Item: (ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:custodian[not(@nullFlavor)]/hl7:assignedOrganization[not(@nullFlavor)]/hl7:telecom[not(@nullFlavor)]" id="d883094e39-false-d883331e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ActReference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="not(@value) or string-length(@value)&gt;0">(ActReference): attribuut @value MOET datatype 'set_cs' hebben</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.27
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:subjectOf
Item: (ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:subjectOf" id="d883094e45-false-d883348e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="string(@typeCode)=('SUBJ') or not(@typeCode)">(ActReference): de waarde van @typeCode MOET 'SUBJ' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="not(@typeCode) or (string-length(@typeCode)&gt;0 and not(matches(@typeCode,'\s')))">(ActReference): attribuut @typeCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:controlActEvent[not(@nullFlavor)])&gt;=1">(ActReference): element hl7:controlActEvent[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:controlActEvent[not(@nullFlavor)])&lt;=1">(ActReference): element hl7:controlActEvent[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.27
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:subjectOf/hl7:controlActEvent[not(@nullFlavor)]
Item: (ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:subjectOf/hl7:controlActEvent[not(@nullFlavor)]" id="d883094e47-false-d883376e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="string(@classCode)=('CACT') or not(@classCode)">(ActReference): de waarde van @classCode MOET 'CACT' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="not(@classCode) or (string-length(@classCode)&gt;0 and not(matches(@classCode,'\s')))">(ActReference): attribuut @classCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="string(@moodCode)=('EVN') or not(@moodCode)">(ActReference): de waarde van @moodCode MOET 'EVN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="not(@moodCode) or (string-length(@moodCode)&gt;0 and not(matches(@moodCode,'\s')))">(ActReference): attribuut @moodCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:effectiveTime[not(@nullFlavor)])&gt;=1">(ActReference): element hl7:effectiveTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="count(hl7:effectiveTime[not(@nullFlavor)])&lt;=1">(ActReference): element hl7:effectiveTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.27
Context: /hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:subjectOf/hl7:controlActEvent[not(@nullFlavor)]/hl7:effectiveTime[not(@nullFlavor)]
Item: (ActReference)
-->
    <rule context="/hl7:MFMT_IN002303NL/hl7:ControlActProcess/hl7:subject[hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]]/hl7:registrationProcess[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.8-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code,@codeSystem)][not(@nullFlavor)]]/hl7:subject2/hl7:ActReference[not(@nullFlavor)]/hl7:subjectOf/hl7:controlActEvent[not(@nullFlavor)]/hl7:effectiveTime[not(@nullFlavor)]" id="d883094e52-false-d883411e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ActReference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="not(*)">(ActReference): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="@value">(ActReference): attribute @value MOET aanwezig zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(ActReference): attribuut @value MOET datatype 'ts' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.27" test="string-length(@value) &gt;= 8">(ActReference): Het attribuut @value moet voor de laatste wijzigingsdatum/tijd tenminste de dag bevatten (YYYYMMDD), maar meer precisie heeft de voorkeur.</assert>
    </rule>
</pattern>